<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Http\Resources\Web\ArchiveCategoriesResource;
use App\Http\Resources\Web\BlogCategoriesResource;
use App\Http\Resources\Web\TherapistCommunityCategoriesResource;
use App\Http\Resources\Web\TherapistCommunitysResource;
use App\Http\Resources\Web\ArchivesResource;
use App\Http\Resources\Web\BroadcastsResource;
use App\Http\Resources\Web\TherapistCommunityReviewsResource;
use App\Http\Resources\Web\TherapistCategoriesResource;
use App\Http\Resources\Web\EventsResource;
use App\Http\Resources\Web\FAQSResource;
use App\Http\Resources\Web\TherapistMainCategoriesResource;
use App\Http\Resources\Web\PostsResource;
use App\Http\Resources\Web\PodcastsResource;
use App\Http\Resources\Web\TherapistReviewsResource;
use App\Http\Resources\Web\TherapistsResource;
use App\Http\Resources\Web\ServiceCategoriesResource;
use App\Http\Resources\Web\ServicesResource;
use App\Http\Resources\Web\TagsResource;
use App\Http\Resources\Web\TestimonialsResource;
use App\Models\ArchiveCategory;
use App\Models\BlogCategory;
use App\Models\TherapistCommunity;
use App\Models\TherapistCommunityCategory;
use App\Models\City;
use App\Models\Country;
use App\Models\Therapist;
use App\Models\Archive;
use App\Models\Broadcast;
use App\Models\TherapistCommunityReview;
use App\Models\State;
use App\Models\TherapistCategory;
use App\Models\Event;
use App\Models\FAQ;
use App\Models\TherapistMainCategory;
use App\Models\Post;
use App\Models\Podcast;
use App\Models\TherapistReview;
use App\Models\Service;
use App\Models\ServiceCategory;
use App\Models\Tag;
use App\Models\Testimonial;
use Illuminate\Support\Arr;
use App\Http\Resources\Web\CommunityPostsResource;

class WebAPIGeneralController extends Controller
{
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchTherapistReviews($req = null,$user_name)
    {
        if ($req != null) {
            $reviews =  TherapistReview::withAll()->active()->whereHas('therapist',function($q) use($user_name){
                $q->where('user_name',$user_name);
                $q->active();
            });
            if ($req->column && $req->column != null && $req->search != null) {
                $reviews = $reviews->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $reviews = $reviews->whereLike(['comment','rating'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $reviews = $reviews->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $reviews = $reviews->OrderBy('id', 'desc');
            }
            $reviews = $reviews->paginate($req->perPage ?? 10);
            $reviews = TherapistReviewsResource::collection($reviews)->response()->getData(true);
            return $reviews;
        }
        $reviews = TherapistReview::withAll()->active()->whereHas('therapist',function($q) use($user_name){
            $q->where('user_name',$user_name);
            $q->active();
        })->orderBy('id', 'desc')->paginate(10);
        $reviews = TherapistReviewsResource::collection($reviews)->response()->getData(true);
        return $reviews;
    }

        /********* Getter For Pagination, Searching And Sorting  ***********/
        public static function searchTherapistCommunityReviews($req = null,$user_name)
        {
            if ($req != null) {
                $reviews =  TherapistCommunityReview::withAll()->active()->whereHas('therapist_community',function($q) use($user_name){
                    $q->where('user_name',$user_name);
                    $q->active();
                });
                if ($req->column && $req->column != null && $req->search != null) {
                    $reviews = $reviews->whereLike($req->column, $req->search);
                } else if ($req->search && $req->search != null) {
                    $reviews = $reviews->whereLike(['comment','rating'], $req->search);
                }
                if ($req->sort_field != null && $req->sort_type != null) {
                    $reviews = $reviews->OrderBy($req->sort_field, $req->sort_type);
                } else {
                    $reviews = $reviews->OrderBy('id', 'desc');
                }
                $reviews = $reviews->paginate($req->perPage ?? 10);
                $reviews = TherapistCommunityReviewsResource::collection($reviews)->response()->getData(true);
                return $reviews;
            }

            $reviews = TherapistCommunityReview::withAll()->active()->whereHas('therapist_community',function($q) use($user_name){
                $q->where('user_name',$user_name);
                $q->active();
            })->orderBy('id', 'desc')->paginate(10);
            $reviews = TherapistCommunityReviewsResource::collection($reviews)->response()->getData(true);
            return $reviews;
        }
    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchTherapists($req = null)
    {
        if ($req != null) {
            $therapists =  Therapist::withAll()->has('user')->whereNotNull('user_name')->active()->approved();
            // if($req->therapist_category){
            //     $therapists = $therapists->whereHas('therapist_categories',function($q) use($req){
            //         $q->where('therapist_categories.slug',$req->therapist_category);
            //     });
            // }
            // else if($req->therapist_main_category){
            //     $therapist_main_category = TherapistMainCategory::where('slug',$req->therapist_main_category)->first();
            //     if($therapist_main_category){
            //         $therapists = $therapists->whereHas('therapist_categories',function($q) use($req,$therapist_main_category){
            //             $q->where('therapist_categories.parent_category_id',$therapist_main_category->id);
            //         });
            //     }
            // }
            if($req->main_category && $req->main_category != 'all' && $req->therapist_category == 'all'){
                $therapists = $therapists->whereHas('therapist_categories',function($q) use($req){
                    $q->whereHas('main_category',function($y) use($req){
                        $y->where('therapist_main_categories.slug',$req->main_category);
                    });
                });
            }
            if($req->therapist_category && $req->therapist_category != 'all'){
                if(is_array($req->therapist_category)){
                     $slugs = Arr::flatten($req->therapist_category);
                        $therapists = $therapists->whereHas('therapist_categories',function($q) use($req , $slugs){
                            $q->whereIn('therapist_categories.slug',$slugs);
                        });
                }else{
                    $therapists = $therapists->whereHas('therapist_categories',function($q) use($req){
                        $q->where('therapist_categories.slug',$req->therapist_category);
                    });
                }
            }
            if($req->language){
                $therapists = $therapists->whereHas('languages',function($q) use($req){
                    $q->where('all_languages.iso_code',$req->language);
                });
            }
            if($req->is_featured){
                $therapists = $therapists->featured();
            }
            if($req->country){
                $therapists = $therapists->where('country_id',$req->country);
            }
            if($req->zip_code){
                $therapists = $therapists->where('zip_code',$req->zip_code);
            }
            if($req->is_top_rated){
                $therapists = $therapists->topRated();
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapists = $therapists->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $therapists = $therapists->whereLike(['first_name','last_name', 'description'], $req->search);
            }
            // if ($req->sort_field != null && $req->sort_type != null) {
            //     $therapists = $therapists->OrderBy($req->sort_field, $req->sort_type);
            // }
            if($req->latitude && $req->longitude){
                $therapists = $therapists->distance($req->latitude,$req->longitude,$req->distance);
                $therapists = $therapists->OrderBy('distance', 'asc');
        }
            else {
                $therapists = $therapists->OrderBy('id', 'desc');
            }
            $therapists = $therapists->paginate($req->perPage ?? 10);
            $therapists = TherapistsResource::collection($therapists)->response()->getData(true);
            return $therapists;
        }
        $therapists = Therapist::withAll()->orderBy('id', 'desc')->paginate(10);
        $therapists = TherapistsResource::collection($therapists)->response()->getData(true);
        return $therapists;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchTherapistCommunitys($req = null)
    {
        if ($req != null) {
            $therapist_communitys =  TherapistCommunity::withAll()->has('user')->whereNotNull('user_name')->active()->approved();
            // dd($req->all());
            if($req->therapist_community_category){
                $therapist_communitys = $therapist_communitys->whereHas('therapist_community_categories',function($q) use($req){
                    $q->where('therapist_community_categories.slug',$req->therapist_community_category);
                });
            }
            if($req->country){
                $therapist_communitys = $therapist_communitys->where('country_id',$req->country);
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapist_communitys = $therapist_communitys->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $therapist_communitys = $therapist_communitys->whereLike(['first_name','last_name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $therapist_communitys = $therapist_communitys->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $therapist_communitys = $therapist_communitys->OrderBy('id', 'desc');
            }
            $therapist_communitys = $therapist_communitys->paginate($req->perPage ?? 10);
            $therapist_communitys = TherapistCommunitysResource::collection($therapist_communitys)->response()->getData(true);
            return $therapist_communitys;
        }
        $therapist_communitys = TherapistCommunity::withAll()->orderBy('id', 'desc')->paginate(10);
            $therapist_communitys = TherapistCommunitysResource::collection($therapist_communitys)->response()->getData(true);
        return $therapist_communitys;
    }

        /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchEvents($req = null)
    {
        if ($req != null) {
            $events =  Event::withAll()->active()->approved()->upcoming()->hasModulePermissions();
            if($req->month){
                $months = ['jan' => 1,'feb' => 2,'mar' => 3,'apr' => 4,'may' => 5,'jun' => 6,'jul' => 7,
                            'aug' => 8,'sep' => 9,'oct' => 10,'nov' => 11,'dec' => 12];
                if(isset($months[$req->month])){
                    $events = $events->whereMonth('starts_at', $months[$req->month]);
                }
            }
            if($req->address){
                $events = $events->whereLike('address', $req->address);
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $events = $events->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $events = $events->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $events = $events->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $events = $events->OrderBy('id', 'desc');
            }
            $events = $events->paginate($req->perPage ?? 10);
            $events = EventsResource::collection($events)->response()->getData(true);
            return $events;
        }
        $events = Event::withAll()->hasModulePermissions()->active()->upcoming()->orderBy('id', 'desc')->paginate(10);
        $events = EventsResource::collection($events)->response()->getData(true);
        return $events;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchPosts($req = null)
    {
        if ($req != null) {
            $posts =  Post::withAll()->active()->hasModulePermissions();
            if($req->tag){
                $posts = $posts->whereHas('tags',function($q) use($req){
                    $q->where('slug',$req->tag);
                });
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $posts = $posts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $posts = $posts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $posts = $posts->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $posts = $posts->OrderBy('id', 'desc');
            }
            $posts = $posts->paginate($req->perPage ?? 10);
            $posts = PostsResource::collection($posts)->response()->getData(true);
            return $posts;
        }
        $posts = Post::withAll()->hasModulePermissions()->orderBy('id', 'desc')->paginate(10);
        $posts = PostsResource::collection($posts)->response()->getData(true);
        return $posts;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchArchives($req = null)
    {
        if ($req != null) {
            $archives =  Archive::withAll()->active()->hasModulePermissions();
            if($req->tag){
                $archives = $archives->whereHas('tags',function($q) use($req){
                    $q->where('slug',$req->tag);
                });
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $archives = $archives->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $archives = $archives->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $archives = $archives->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $archives = $archives->OrderBy('id', 'desc');
            }
            $archives = $archives->paginate($req->perPage ?? 10);
            $archives = ArchivesResource::collection($archives)->response()->getData(true);
            return $archives;
        }
        $archives = Archive::withAll()->hasModulePermissions()->orderBy('id', 'desc')->paginate(10);
        $archives = ArchivesResource::collection($archives)->response()->getData(true);
        return $archives;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchBroadcasts($req = null)
    {
        if ($req != null) {
            $broadcasts =  Broadcast::withAll()->active()->hasModulePermissions();
            if($req->tag){
                $broadcasts = $broadcasts->whereHas('tags',function($q) use($req){
                    $q->where('slug',$req->tag);
                });
            }
            if($req->type){
                $broadcasts = $broadcasts->whereLike('file_type', $req->type);
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $broadcasts = $broadcasts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $broadcasts = $broadcasts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $broadcasts = $broadcasts->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $broadcasts = $broadcasts->OrderBy('id', 'desc');
            }
            $broadcasts = $broadcasts->paginate($req->perPage ?? 10);
            $broadcasts = BroadcastsResource::collection($broadcasts)->response()->getData(true);
            return $broadcasts;
        }
        $broadcasts = Broadcast::withAll()->hasModulePermissions()->orderBy('id', 'desc')->paginate(10);
        $broadcasts = BroadcastsResource::collection($broadcasts)->response()->getData(true);
        return $broadcasts;
    }

       /********* Getter For Pagination, Searching And Sorting  ***********/
       public static function searchPodcasts($req = null)
       {
           if ($req != null) {
               $podcasts =  Podcast::withAll()->active()->hasModulePermissions();
               if($req->tag){
                    $podcasts = $podcasts->whereHas('tags',function($q) use($req){
                        $q->where('slug',$req->tag);
                    });
                }
                if($req->type){
                    $podcasts = $podcasts->whereLike('file_type', $req->type);
                }
               if ($req->column && $req->column != null && $req->search != null) {
                   $podcasts = $podcasts->whereLike($req->column, $req->search);
               } else if ($req->search && $req->search != null) {
                   $podcasts = $podcasts->whereLike(['name', 'description'], $req->search);
               }
               if ($req->sort_field != null && $req->sort_type != null) {
                   $podcasts = $podcasts->OrderBy($req->sort_field, $req->sort_type);
               } else {
                   $podcasts = $podcasts->OrderBy('id', 'desc');
               }
               $podcasts = $podcasts->paginate($req->perPage ?? 10);
               $podcasts = PodcastsResource::collection($podcasts)->response()->getData(true);
               return $podcasts;
           }
           $podcasts = Podcast::withAll()->hasModulePermissions()->orderBy('id', 'desc')->paginate(10);
           $podcasts = PodcastsResource::collection($podcasts)->response()->getData(true);
           return $podcasts;
       }

             /********* Getter For Pagination, Searching And Sorting  ***********/
             public static function searchServices($req = null)
             {
                 if ($req != null) {
                     $services =  Service::approved()->withAll()->active()->hasModulePermissions();
                     if($req->tag){
                          $services = $services->whereHas('tags',function($q) use($req){
                              $q->where('slug',$req->tag);
                          });
                      }
                      if($req->service_category){
                        $services = $services->whereHas('service_category',function($q) use($req){
                            $q->where('slug',$req->service_category);
                        });
                    }
                     if ($req->column && $req->column != null && $req->search != null) {
                         $services = $services->whereLike($req->column, $req->search);
                     } else if ($req->search && $req->search != null) {
                         $services = $services->whereLike(['name', 'description'], $req->search);
                     }
                     if ($req->sort_field != null && $req->sort_type != null) {
                         $services = $services->OrderBy($req->sort_field, $req->sort_type);
                     } else {
                         $services = $services->OrderBy('id', 'desc');
                     }
                     $services = $services->paginate($req->perPage ?? 10);
                     $services = ServicesResource::collection($services)->response()->getData(true);
                     return $services;
                 }
                 $services = Service::withAll()->approved()->hasModulePermissions()->orderBy('id', 'desc')->paginate(10);
                 $services = ServicesResource::collection($services)->response()->getData(true);
                 return $services;
             }


    public static function getCountries($request){
        $countries = Country::active()->get();
        return $countries;
    }
    public static function getStates($request){
        $states = State::active()->where('country_id',$request->country_id)->get();
        return $states;
    }

    public static function getTestimonials($request){
        $testimonials = Testimonial::active()->get();
        $testimonials = TestimonialsResource::collection($testimonials);
        return $testimonials;
    }

    public static function getTherapistCommunityCategories($request){
        $therapist_community_categories = TherapistCommunityCategory::active()->get();
        $therapist_community_categories = TherapistCommunityCategoriesResource::collection($therapist_community_categories);
        return $therapist_community_categories;
    }

    public static function getTags($request){
        $tags = Tag::active()->get();
        $tags = TagsResource::collection($tags);
        return $tags;
    }

    public static function getServiceCategories($request){
        $service_categories = ServiceCategory::active();
        if($request->has_services){
        $service_categories = $service_categories->whereHas('services',function($q){
            $q->active();
        });
        }
        $service_categories = $service_categories->get();
        $service_categories = ServiceCategoriesResource::collection($service_categories);
        return $service_categories;
    }

    public static function getBlogCategories($request){
        $blog_categories = BlogCategory::active()->get();
        $blog_categories = BlogCategoriesResource::collection($blog_categories);
        return $blog_categories;
    }

    public static function getFaqs($request){
        $faqs = FAQ::active()->get();
        $faqs = FAQSResource::collection($faqs);
        return $faqs;
    }

    public static function getArchiveCategories($request){
        $archive_categories = ArchiveCategory::active()->get();
        $archive_categories = ArchiveCategoriesResource::collection($archive_categories);
        return $archive_categories;
    }

    public static function getTherapistCategories($request){
        $therapist_categories = TherapistCategory::active()->get();
        $therapist_categories = TherapistCategoriesResource::collection($therapist_categories);
        return $therapist_categories;
    }
    public static function getFeaturedTherapistCategories($request){
        // $featured_therapist_categories = TherapistMainCategory::active()->featured()->whereHas('categories',function($q){
        //     $q->active();
        // })->withAll()->withChildrens()->get();
        $featured_therapist_categories = TherapistMainCategory::active()->featured()->get();
        $featured_therapist_categories = TherapistMainCategoriesResource::collection($featured_therapist_categories);
        return $featured_therapist_categories;

    }

    public static function getCities($request){
        $cities = City::active()->where('country_id',$request->country_id)->where('state_id',$request->state_id)->get();
        return $cities;
    }
    public static function getFeaturedTherapists($request){
        $featured_therapists = Therapist::withAll()->has('user')->whereNotNull('user_name')->active()->approved()->featured();
        if($request->latitude && $request->longitude){
            $featured_therapists = $featured_therapists->distance($request->latitude,$request->longitude);
            $featured_therapists = $featured_therapists->OrderBy('distance', 'asc');
        }
        $featured_therapists = $featured_therapists->get();

        $featured_therapists = TherapistsResource::collection($featured_therapists);
        return $featured_therapists;
    }

    public static function getTopRatedTherapists($request){
        $top_rated_therapists = Therapist::withAll($request)->has('user')->whereNotNull('user_name')->active()->approved()->topRated()->get();
        $top_rated_therapists = TherapistsResource::collection($top_rated_therapists);
        return $top_rated_therapists;
    }

    public static function getPremiumTherapists($request){
        $premium_therapists = Therapist::withAll()->has('user')->whereNotNull('user_name')->active()->approved()->premium();
        $premium_therapists = $premium_therapists->get();
        $premium_therapists = TherapistsResource::collection($premium_therapists);
        return $premium_therapists;
    }
    public static function getFeaturedTags($request){
        $featured_tags = Tag::withAll()->active()->get();
        $featured_tags = TagsResource::collection($featured_tags);
        return $featured_tags;
    }

    public static function getFeaturedEvents($request){
        $featured_events = Event::withAll()->active()->upcoming()->featured()->get();
        $featured_events = EventsResource::collection($featured_events);
        return $featured_events;
    }

    public static function getSpotlightTherapists($request){
        $spotlight_therapists = Therapist::withAll()->has('user')->whereNotNull('user_name')->active()->approved()->featured()->get();
        $spotlight_therapists = TherapistsResource::collection($spotlight_therapists);
        return $spotlight_therapists;
    }

    public static function getFeaturedTherapistCommunitys($request){
        $featured_therapist_communitys = TherapistCommunity::withAll()->has('user')->whereNotNull('user_name')->active()->approved()->featured()->get();
        $featured_therapist_communitys->each(function ($therapist_community) {
            $therapist_community->setRelation(
                'therapist_community_therapists',
                $therapist_community->therapist_community_therapists->take(4)
            );
        });
        $featured_therapist_communitys = TherapistCommunitysResource::collection($featured_therapist_communitys);
        return $featured_therapist_communitys;
    }

    public static function getTrendingCommunityPosts($request)
    {
        $community_posts = Post::withAll()->withChildren()->active()->latest()->get();
        $community_posts = CommunityPostsResource::collection($community_posts);
        return $community_posts;
    }
}
